﻿using System;
using System.Collections.Generic;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
    public partial class storage_pool
    {
        public storage_pool()
        {
            description = string.Empty;
            master_domain_version = 0;
			compatibility_version = new Version("2.1");
        }

        public storage_pool(System.String description, System.Guid id, System.String name, System.Int32 storage_pool_type, System.Int32 status)
			: this()
        {
            this.description = description;
            this.Id = id;
            this.name = name;
            this.storage_pool_type = (StorageType) storage_pool_type;
            this.status = (StoragePoolStatus)status;
        }


        #region IVdcQueryable Members
        //public event PropertyChangedEventHandler PropertyChanged;
        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return Id; }
        }
        #endregion
        #region INotifyPropertyChanged Members
        private static readonly List<string> _spProperties = new List<string> { "name", "description", "status", "storage_pool_type", "compatibility_version" };
        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return _spProperties; }
        }

    
        #endregion

    }
}

